#include <iostream>

using namespace std;
typedef long long ll;

constexpr ll MOD = 998244353;

constexpr int MAXN = 200000;
constexpr int K = 19;

int score[MAXN];
int stscore[K][MAXN];
int scoreq(int l, int r) {
    if (r <= l) return 0;
    int lg = __lg(r - l);
    return min(stscore[lg][l], stscore[lg][r - (1 << lg)]);
}

int opt[MAXN];
int stopt[K][MAXN];
int optq(int l, int r) {
    if (r <= l) return 0;
    int lg = __lg(r - l);
    return max(stopt[lg][l], stopt[lg][r - (1 << lg)]);
}


int main()
{
    int n, k;
    cin >> n >> k;
    string s;
    cin >> s;
    for (int i = 0; i < n; ++i) s[i] = (s[i] == ')');
    score[0] = 0;
    opt[0] = 0;
    for (int i = 0; i < n; ++i) {
        score[i] = (i ? score[i-1] : 0) - s[i] + !s[i];
        opt[i] = -2 * score[i] - i;
        stscore[0][i] = score[i];
        stopt[0][i] = opt[i];
    }
    for (int k = 1; k < K; ++k) {
        for (int i = 0; i < n - (1 << k) + 1; ++i) {
            stscore[k][i] = min(stscore[k-1][i], stscore[k-1][i + (1 << (k - 1))]);
            stopt[k][i] = max(stopt[k-1][i], stopt[k-1][i + (1 << (k-1))]);
        }
    }
    while (k--) {
        int l, r;
        cin >> l >> r;
        --l;
        int slg = r - l;
        int rscore = score[r-1];
        int lmscore = (l ? score[l-1] : 0);
        int bdt = rscore - lmscore; //( - )
        //x - y = bdt, x + y = slg; x = sum/2, y = slg - bdt / 2
        int cbc = (slg - bdt) / 2;
        int obc = (slg + bdt) / 2;
        int cbo = cbc - obc;
        int supng = scoreq(l, r) - lmscore;
        if (supng > 0) supng = 0;
        int bopt = optq(l, r) + l + 2 * lmscore - 1;
        if (bopt < 0) bopt = 0;
        if (cbo == 0) {
//            cout << -2*supng << ' ' << -bopt << endl;
            cout << -2*supng - bopt << '\n';
        } else if (cbo > 0) {
            supng += cbo;
            if (supng > 0) supng = 0;
            bopt -= 2 * cbo;
            if (bopt < 0) bopt = 0;
//            cout << -2*supng << ' ' << -bopt << ' ' << cbo << endl;
            cout << -2*supng - bopt + cbo << '\n';
        } else { // (cbo < 0)
            int cbd = -cbo;
//            cout << -2*supng << ' ' << -bopt << ' ' << cbd << endl;
            cout << -2*supng - bopt + cbd << '\n';
        }
    }
    return 0;
}
